<?php $__env->startSection('title', $list->name . ": " . trans('messages.subscribers')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<?php echo $__env->make("lists._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

				<?php echo $__env->make("lists._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				<h2 class="text-bold text-teal-800 mb-10"><i class="icon-users4"></i> <?php echo e(trans('messages.subscribers')); ?></h2>

				<form class="listing-form"
					data-url="<?php echo e(action('SubscriberController@listing', $list->uid)); ?>"
					per-page="<?php echo e(Acelle\Model\Subscriber::$itemsPerPage); ?>"
				>
					<div class="row top-list-controls">
						<div class="col-md-10">
							<?php if($list->readCache('SubscriberCount', 0) > 0): ?>
								<div class="filter-box">
									<span class="mr-10">
										<?php echo $__env->make('helpers.select_tool', [
											'disable_all_items' => false
										], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
										<div class="btn-group list_actions hide mr-0">
											<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
												<?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
											</button>
											<ul class="dropdown-menu">
												<li>
													<a link-confirm="<?php echo e(trans('messages.subscribe_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@subscribe', $list->uid)); ?>">
														<i class="icon-enter"></i> <?php echo e(trans('messages.subscribe')); ?>

													</a>
												</li>
												<li>
													<a link-confirm="<?php echo e(trans('messages.unsubscribe_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@unsubscribe', $list->uid)); ?>">
														<i class="icon-exit"></i> <?php echo e(trans('messages.unsubscribe')); ?>

													</a>
												</li>
												<li>
													<a href="#" class="copy_move_subscriber"
														data-url="<?php echo e(action('SubscriberController@copyMoveForm', [
															'from_uid' => $list->uid,
															'action' => 'copy',
														])); ?>">
															<i class="icon-copy4"></i> <?php echo e(trans('messages.copy_to')); ?>

													</a>
												</li>
												<li>
													<a href="#move" class="copy_move_subscriber"
														data-url="<?php echo e(action('SubscriberController@copyMoveForm', [
															'from_uid' => $list->uid,
															'action' => 'move',
														])); ?>">
														<i class="icon-move-right"></i> <?php echo e(trans('messages.move_to')); ?>

													</a>
												</li>
												<li>
													<a delete-confirm="<?php echo e(trans('messages.delete_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@delete', $list->uid)); ?>">
														<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

													</a>
												</li>
											</ul>
										</div>
										<!--<div class="checkbox inline check_all_list">
											<label>
												<input type="checkbox" class="styled check_all">
											</label>
										</div>-->
									</span>
									<span class="filter-group">
										<span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
										<select class="select" name="sort-order">
											<option value="subscribers.email"><?php echo e(trans('messages.email')); ?></option>
											<option value="subscribers.created_at"><?php echo e(trans('messages.created_at')); ?></option>
											<option value="subscribers.updated_at"><?php echo e(trans('messages.updated_at')); ?></option>
										</select>
										<button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
											<i class="icon-sort-amount-asc"></i>
										</button>
									</span>
									<span class="">
										<select class="select" name="status">
											<option value=""><?php echo e(trans('messages.all_subscribers')); ?></option>
											<option value="subscribed"><?php echo e(trans('messages.subscribed')); ?></option>
											<option value="unsubscribed"><?php echo e(trans('messages.unsubscribed')); ?></option>
											<option value="unconfirmed"><?php echo e(trans('messages.unconfirmed')); ?></option>
											<option value="spam-reported"><?php echo e(trans('messages.spam-reported')); ?></option>
											<option value="blacklisted"><?php echo e(trans('messages.blacklisted')); ?></option>
										</select>
									</span>
									<span class="filter-group ml-10">
										<select class="select" name="verification_result">
											<option value=""><?php echo e(trans('messages.all_verification')); ?></option>
											<?php foreach(Acelle\Model\EmailVerification::resultSelectOptions() as $option): ?>
												<option value="<?php echo e($option['value']); ?>">
													<?php echo e($option['text']); ?>

												</option>
											<?php endforeach; ?>
										</select>
									</span>
									<div class="btn-group list_columns mr-10">
										<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
											<?php echo e(trans('messages.columns')); ?> <span class="caret"></span>
										</button>
										<ul class="dropdown-menu dropdown-menu-right">
											<?php foreach($list->getFields as $field): ?>
												<?php if($field->tag != "EMAIL"): ?>
													<li>
														<div class="checkbox">
															<label>
																<input <?php echo e((true ? "checked='checked'" : "")); ?> type="checkbox" id="<?php echo e($field->tag); ?>" name="columns[]" value="<?php echo e($field->uid); ?>" class="styled">
																<?php echo e($field->label); ?>

															</label>
														</div>
													</li>
												<?php endif; ?>
											<?php endforeach; ?>
											<li>
												<div class="checkbox">
													<label>
														<input checked="checked" type="checkbox" id="created_at" name="columns[]" value="created_at" class="styled">
														<?php echo e(trans('messages.created_at')); ?>

													</label>
												</div>
											</li>
											<li>
												<div class="checkbox">
													<label>
														<input checked="checked" type="checkbox" id="updated_at" name="columns[]" value="updated_at" class="styled">
														<?php echo e(trans('messages.updated_at')); ?>

													</label>
												</div>
											</li>
										</ul>
									</div>
									<span class="text-nowrap">
										<input name="keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
										<i class="icon-search4 keyword_search_button"></i>
									</span>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-md-2 text-right">
							<a href="<?php echo e(action("SubscriberController@create", $list->uid)); ?>" type="button" class="btn bg-info-800">
								<i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_subscriber')); ?>

							</a>
						</div>
					</div>

					<div class="pml-table-container">



					</div>
				</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>