<?php $__env->startSection('title', trans('messages.sending_servers')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-list2"></i> <?php echo e(trans('messages.sending_servers')); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="alert alert-info">
        <p>
            <span class="text-semibold"><?php echo e(trans('messages.notification.note')); ?> </span> <?php echo e(trans('messages.notification.sending_servers')); ?>

        </p>
    </div>
    <p><?php echo e(trans('messages.sending_server.wording')); ?></p>


    <form class="listing-form"
        sort-url="<?php echo e(action('Admin\SendingServerController@sort')); ?>"
        data-url="<?php echo e(action('Admin\SendingServerController@listing')); ?>"
        per-page="<?php echo e(Acelle\Model\SendingServer::$itemsPerPage); ?>"
    >
        <div class="row top-list-controls">
            <div class="col-md-10">
                <?php if($items->count() >= 0): ?>
                    <div class="filter-box">
                        <div class="btn-group list_actions hide">
                            <button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
                                <?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a link-confirm="<?php echo e(trans('messages.enable_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@enable')); ?>"><i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?></a></li>
                                <li><a link-confirm="<?php echo e(trans('messages.disable_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@disable')); ?>"><i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?></a></li>
                                <li><a delete-confirm="<?php echo e(trans('messages.delete_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@delete')); ?>"><i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?></a></li>
                            </ul>
                        </div>
                        <div class="checkbox inline check_all_list">
                            <label>
                                <input type="checkbox" class="styled check_all">
                            </label>
                        </div>
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
                            <select class="select" name="sort-order">
                                <option value="sending_servers.name"><?php echo e(trans('messages.name')); ?></option>
                                <option value="sending_servers.created_at"><?php echo e(trans('messages.created_at')); ?></option>
                                <option value="sending_servers.updated_at"><?php echo e(trans('messages.updated_at')); ?></option>
                            </select>
                            <button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
                                <i class="icon-sort-amount-asc"></i>
                            </button>
                        </span>
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.type')); ?></span>
                            <select class="select" name="type">
                                <option value=""><?php echo e(trans('messages.all')); ?></option>
                                <?php foreach(Acelle\Model\SendingServer::types() as $key => $type): ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e(trans('messages.' . $key)); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </span>
                        <span class="text-nowrap">
                            <input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
                            <i class="icon-search4 keyword_search_button"></i>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <?php if(Auth::user()->admin->can('create', new Acelle\Model\SendingServer())): ?>
                <div class="col-md-2 text-right">
                    <a href="<?php echo e(action('Admin\SendingServerController@select')); ?>" type="button" class="btn bg-info-800">
                        <i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_sending_server')); ?>

                    </a>
                </div>
            <?php endif; ?>
        </div>

        <div class="pml-table-container">
        </div>
    </form>


    <!-- Basic modal -->
    <div id="server_types" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                    <div class="modal-header bg-teal">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h2 class="modal-title"><?php echo e(trans('messages.select_server_type')); ?></h2>
                    </div>

                    <div class="modal-body">

                        <ul class="modern-listing big-icon no-top-border-list mt-0">

                            <?php foreach(Acelle\Model\SendingServer::types() as $key => $type): ?>

                                <li>
                                    <a href="<?php echo e(action('Admin\SendingServerController@create', ["type" => $key])); ?>" class="btn btn-info bg-info-800"><?php echo e(trans('messages.choose')); ?></a>
                                    <span class="server-avatar server-avatar-<?php echo e($key); ?>">
                                        <i class="icon-server"></i>
                                    </span>
                                    <h4><a href="<?php echo e(action('Admin\SendingServerController@create', ["type" => $key])); ?>"><?php echo e(trans('messages.' . $key)); ?></a></h4>
                                    <p>
                                        <?php echo e(trans('messages.sending_server_intro_' . $key)); ?>

                                    </p>
                                </li>

                            <?php endforeach; ?>

                        </ul>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                    </div>
            </div>
        </div>
    </div>
    <!-- /basic modal -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>