<?php if($segments->count() > 0): ?>
    <table class="table table-box pml-table"
           current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
    >
        <?php foreach($segments as $key => $item): ?>
            <tr>
                <td width="1%">
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                            <label>
                                <input type="checkbox" class="node styled"
                                       name="ids[]"
                                       value="<?php echo e($item->uid); ?>"
                                />
                            </label>
                        </div>
                    </div>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search"
                           href="<?php echo e(action('SegmentController@subscribers', ['list_uid' => $list->uid, 'uid' => $item->uid])); ?>"><?php echo e($item->name); ?></a>
                    </h5>
                    <span class="text-muted"><?php echo e(trans('messages.created_at')); ?>

                        : <?php echo e(Tool::formatDateTime($item->created_at)); ?></span>
                </td>
                <td>
                    <div class="single-stat-box pull-left">

                        <a class="kq_search"
                           href="<?php echo e(action('SegmentController@subscribers', ['list_uid' => $list->uid, 'uid' => $item->uid])); ?>">
                            <span class="no-margin stat-num"><?php echo e(number_with_delimiter($item->readCache('SubscriberCount', '#'))); ?></span>
                        </a>
                        <br/>
                        <span class="text-muted"><?php echo e(trans("messages.subscribers")); ?></span>
                    </div>
                    <br style="clear:both"/>
                </td>

                <td class="text-right text-nowrap">
                    <?php if(\Gate::allows('update', $item)): ?>
                        <a href="<?php echo e(action('SegmentController@edit', ['list_uid' => $list->uid, "uids" => $item->uid])); ?>"
                           type="button" class="btn bg-grey btn-icon">
                            <i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?>

                        </a>
                    <?php endif; ?>
                    <div class="btn-group">
                        <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span
                                    class="caret ml-0"></span></button>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <?php if(\Gate::allows('delete', $item)): ?>
                                <li><a class="ajax_link"
                                       delete-confirm="<?php echo e(trans('messages.delete_segments_confirm')); ?>"
                                       href="<?php echo e(action('SegmentController@delete', ['list_uid' => $list->uid, "uids" => $item->uid])); ?>"><i
                                                class="icon-trash"></i> <?php echo e(trans("messages.delete")); ?></a></li>
                            <?php endif; ?>
                            <?php if(\Gate::allows('export', $item)): ?>
                                <li>
                                    <a href="<?php echo e(action('SegmentController@viewExport', ['list_uid' => $list->uid, 'uid' => $item->uid])); ?>"><i
                                                class="icon-upload4"></i> <?php echo e(trans("messages.export")); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </td>

            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $segments], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($segments->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <i class="icon-make-group"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-make-group"></i>
		<span class="line-1">
			<?php echo e(trans('messages.segment_empty_line_1')); ?>

		</span>
    </div>
<?php endif; ?>
