<?php if($currencies->count() > 0): ?>
	<table class="table table-box pml-table"
		current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
	>
		<?php foreach($currencies as $key => $item): ?>
			<tr>
				<td width="1%">
					<div class="text-nowrap">
						<div class="checkbox inline">
							<label>
								<input type="checkbox" class="node styled"
									name="ids[]"
									value="<?php echo e($item->uid); ?>"
								/>
							</label>
						</div>
					</div>
				</td>
				<td>
					<h5 class="no-margin text-bold">
						<a class="kq_search" href="<?php echo e(action('Admin\CurrencyController@edit', $item->uid)); ?>"><?php echo e($item->name); ?></a>
					</h5>
					<?php if(Auth::user()->can('readAll', $item)): ?>
						<?php echo $__env->make('admin.modules.admin_line', ['admin' => $item->admin], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
						<br />
					<?php endif; ?>
					<span class="text-muted">
						<?php echo e(trans('messages.updated_at')); ?>

						<?php echo e(Acelle\Library\Tool::formatDateTime($item->updated_at)); ?>

					</span>
				</td>
				<td class="stat-fix-size-sm">
					<div class="single-stat-box pull-left">
						<span class="no-margin stat-num kq_search"><?php echo e($item->code); ?></span>
						<br />
						<span class="text-muted"><?php echo e(trans("messages.code")); ?></span>
					</div>
				</td>
				<td class="stat-fix-size-sm">
					<div class="single-stat-box pull-left">
						<span class="no-margin stat-num kq_search"><?php echo e($item->format); ?></span>
						<br />
						<span class="text-muted"><?php echo e(trans("messages.currency_format")); ?></span>
					</div>
				</td>
				<td class="stat-fix-size">
					<span class="text-muted2 list-status pull-left">
						<span class="label label-flat bg-<?php echo e($item->status); ?>"><?php echo e($item->status); ?></span>
					</span>
				</td>
				<td class="text-right text-nowrap" width="5%">
					<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('update', $item)): ?>
						<a href="<?php echo e(action('Admin\CurrencyController@edit', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey-600 btn-icon"><i class="icon icon-pencil pr-0 mr-0"></i></a>
					<?php endif; ?>
					<?php if(Auth::user()->can('delete', $item) || Auth::user()->can('enable', $item) || Auth::user()->can('disable', $item) || Auth::user()->can('delete', $item)): ?>
						<div class="btn-group">
							<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
							<ul class="dropdown-menu dropdown-menu-right">
								<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('enable', $item)): ?>
									<li>
										<a link-confirm="<?php echo e(trans('messages.enable_admins_confirm')); ?>" href="<?php echo e(action('Admin\CurrencyController@enable', ["uids" => $item->uid])); ?>">
											<i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('disable', $item)): ?>
									<li>
										<a link-confirm="<?php echo e(trans('messages.disable_admins_confirm')); ?>" href="<?php echo e(action('Admin\CurrencyController@disable', ["uids" => $item->uid])); ?>">
											<i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

										</a>
									</li>
								<?php endif; ?>
								<li>
									<a delete-confirm="<?php echo e(trans('messages.delete_currencies_confirm')); ?>" href="<?php echo e(action('Admin\CurrencyController@delete', ['uids' => $item->uid])); ?>">
										<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

									</a>
								</li>
							</ul>
						</div>
					<?php endif; ?>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<?php echo $__env->make('elements/_per_page_select', ["items" => $currencies], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo e($currencies->links()); ?>

<?php elseif(!empty(request()->filters)): ?>
	<div class="empty-list">
		<i class="icon-clipboard2"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
	</div>
<?php else: ?>
	<div class="empty-list">
		<i class="icon-currencies"></i>
		<span class="line-1">
			<?php echo e(trans('messages.plan_empty_line_1')); ?>

		</span>
	</div>
<?php endif; ?>
