<?php if($plans->count() > 0): ?>
    <table class="table table-box pml-table"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
    >
        <?php foreach($plans as $key => $plan): ?>
            <tr>
                <td width="1%">
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                            <input type="hidden" class="node styled"
                                custom-order="<?php echo e($plan->custom_order); ?>"
                                name="ids[]"
                                value="<?php echo e($plan->uid); ?>"
                            />
                        </div>
                        <?php if(request()->sort_order == 'custom_order' && empty(request()->keyword)): ?>
                            <i data-action="move" class="icon icon-more2 list-drag-button"></i>
                        <?php endif; ?>
                    </div>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <i class="icon-square plan-list-color-icon" style="color: <?php echo e($plan->color); ?>"></i>
                        <span class="kq_search" href="<?php echo e(action('Admin\PlanController@edit', $plan->uid)); ?>">
                            <?php echo e($plan->name); ?>

                        </span>
                    </h5>
                    <?php if(Auth::user()->can('readAll', $plan)): ?>
                        <?php echo $__env->make('admin.modules.admin_line', ['admin' => $plan->admin], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php endif; ?>
                </td>
                <td>
                    <h5 class="no-margin text-bold kq_search">
                        <?php echo e(\Acelle\Library\Tool::format_price($plan->price, $plan->currency->format)); ?>

                    </h5>
                    <span class="text-muted"><?php echo e($plan->displayFrequencyTime()); ?></span>
                </td>
                <td>
                    <h5 class="no-margin text-bold kq_search">
                        <?php echo e($plan->displayTotalQuota()); ?>

                    </h5>
                    <span class="text-muted"><?php echo e(trans('messages.sending_total_quota_label')); ?></span>
                </td>
                <td>
                    <h5 class="no-margin text-bold kq_search">
                        <?php echo e(\Acelle\Library\Tool::formatDate($plan->updated_at)); ?>

                    </h5>
                    <span class="text-muted"><?php echo e(trans('messages.updated_at')); ?></span>
                </td>
                <td>
                    <span class="text-muted2 list-status pull-left">
                        <span class="label label-flat bg-<?php echo e($plan->status); ?>"><?php echo e(trans('messages.plan_status_' . $plan->status)); ?></span>
                    </span>
                </td>
                <td class="text-right text-nowrap" width="5%">
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('update', $plan)): ?>
                        <a href="<?php echo e(action('Admin\PlanController@edit', $plan->uid)); ?>" type="button" class="btn bg-grey btn-icon"> <i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
                    <?php endif; ?>
                    <?php if(\Auth::user()->can('delete', $plan) || \Auth::user()->can('disable', $plan) || \Auth::user()->can('enable', $plan) || \Auth::user()->can('copy', $plan)): ?>
                        <div class="btn-group">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <?php if(Auth::user()->admin->can('enable', $plan)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.enable_plans_confirm')); ?>" href="<?php echo e(action('Admin\PlanController@enable', ["uids" => $plan->uid])); ?>">
                                            <i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(Auth::user()->admin->can('disable', $plan)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.disable_plans_confirm')); ?>" href="<?php echo e(action('Admin\PlanController@disable', ["uids" => $plan->uid])); ?>">
                                            <i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                 <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('copy', $plan)): ?>
                                    <li>
                                        <a data-name="<?php echo e('Copy of '); ?><?php echo e($plan->name); ?>" data-uid="<?php echo e($plan->uid); ?>" title="<?php echo e(trans('messages.copy')); ?>" class="copy-plan-link">
                                            <i class="icon icon-copy4"></i> <?php echo e(trans('messages.copy')); ?>

                                        </a>
                                    </li>
                                  <?php endif; ?>
                                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('delete', $plan)): ?>
                                    <li>
                                        <a list-delete-confirm="<?php echo e(action('Admin\PlanController@deleteConfirm', ['uids' => $plan->uid])); ?>" href="<?php echo e(action('Admin\PlanController@delete', ['uids' => $plan->uid])); ?>" title="<?php echo e(trans('messages.delete')); ?>" class="">
                                            <i class="icon icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $plans], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($plans->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <i class="icon-clipboard2"></i>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result')); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-clipboard2"></i>
        <span class="line-1">
            <?php echo e(trans('messages.plan_empty_line_1')); ?>

        </span>
    </div>
<?php endif; ?>
