                        <?php if($automations->count() > 0): ?>
							<table class="table table-box pml-table"
                                current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
                            >
								<?php foreach($automations as $key => $automation): ?>
									<tr>
										<td width="1%">
											<div class="text-nowrap">
												<div class="checkbox inline">
													<label>
														<input type="checkbox" class="node styled"
															custom-order="<?php echo e($automation->custom_order); ?>"
															name="ids[]"
															value="<?php echo e($automation->uid); ?>"
														/>
													</label>
												</div>
												<?php if(request()->sort_order == 'custom_order' && empty(request()->keyword)): ?>
													<i data-action="move" class="icon icon-more2 list-drag-button"></i>
												<?php endif; ?>
											</div>
										</td>
										<td>
											<h5 class="no-margin text-bold">
												<a class="kq_search" href="<?php echo e(action('AutomationController@edit', $automation->uid)); ?>">
													<?php echo e($automation->name); ?>

												</a>
											</h5>
											<?php if($automation->getInitEvent()->displayMessage()): ?>
												<span class="text-mutedz">
													<span data-popup="tooltip" title="<?php echo e(strip_tags($automation->getInitEvent()->displayMessage())); ?>" class="auto-event-substr"><?php echo $automation->getInitEvent()->displayMessage(); ?></span>
												</span>
											<?php endif; ?>
											<div class="text-semibold" data-popup="tooltip" title="<?php echo e($automation->displayRecipients()); ?>">
												<?php echo e(number_with_delimiter($automation->readCache('SubscriberCount', 0, true))); ?> <?php echo e(trans('messages.recipients')); ?>

											</div>
										</td>
										<td>
											<h5 class="no-margin">
												<?php echo e(trans('messages.auto_event_' . $automation->getInitEvent()->event_type)); ?>

											</h5>
											<span class="text-muted2"><?php echo e(trans('messages.type')); ?></span>
										</td>
										<td>
											<h5 class="no-margin text-teal-800 stat-num">
												<?php echo e($automation->autoEvents()->count()); ?>

											</h5>
											<span class="text-muted2"><?php echo e(trans('messages.triggers')); ?></span>
										</td>
										<td>
											<h5 class="no-margin text-teal-800 stat-num">
												<?php echo e($automation->getCampaigns()->count()); ?>

											</h5>
											<span class="text-muted2"><?php echo e(trans('messages.emails')); ?></span>
										</td>
										<td>
											<span class="no-margin text-bold">
												<?php echo e(Tool::formatDateTime($automation->created_at)); ?>

											</span>
											<br />
											<span class="text-muted"><?php echo e(trans('messages.created_at')); ?></span>
										</td>
										<td class="text-center">
											<span class="text-muted2 list-status">
												<span class="label label-flat bg-<?php echo e($automation->status); ?>"><?php echo e(trans('messages.automation_status_' . $automation->status)); ?></span>
											</span>
										</td>
										<td class="text-right text-nowrap">
											<?php if(\Gate::allows('update', $automation)): ?>
												<a data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" href="<?php echo e(action('AutomationController@edit', $automation->uid)); ?>" type="button" class="btn bg-grey btn-icon"> <i class="icon-pencil"></i></a>
											<?php endif; ?>
											<?php if(\Gate::allows('overview', $automation)): ?>
												<a data-popup="tooltip" title="<?php echo e(trans('messages.overview')); ?>" href="<?php echo e(action('AutomationController@overviewWorkflow', $automation->uid)); ?>" type="button" class="btn bg-teal-800 btn-icon">
													<i class="icon-stats-growth mr-0 pr-0"></i>
												</a>
											<?php endif; ?>
											<?php if(\Gate::allows('delete', $automation) || Auth::user()->can('disable', $automation) || Auth::user()->can('enable', $automation)): ?>
												<div class="btn-group">
													<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
													<ul class="dropdown-menu dropdown-menu-right">
														<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('enable', $automation)): ?>
															<li>
																<a data-method="PATCH" link-confirm="<?php echo e(trans('messages.enable_automations_confirm')); ?>" href="<?php echo e(action('AutomationController@enable', ["uids" => $automation->uid])); ?>">
																	<i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

																</a>
															</li>
														<?php endif; ?>
														<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('disable', $automation)): ?>
															<li>
																<a data-method="PATCH" link-confirm="<?php echo e(trans('messages.disable_automations_confirm')); ?>" href="<?php echo e(action('AutomationController@disable', ["uids" => $automation->uid])); ?>">
																	<i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

																</a>
															</li>
														<?php endif; ?>
														<?php if(\Gate::allows('delete', $automation)): ?>
															<li><a data-method='delete' delete-confirm="<?php echo e(trans('messages.delete_automations_confirm')); ?>" href="<?php echo e(action('AutomationController@delete', ["uids" => $automation->uid])); ?>"><i class="icon-trash"></i> <?php echo e(trans("messages.delete")); ?></a></li>
														<?php endif; ?>
													</ul>
												</div>
											<?php endif; ?>
										</td>
									</tr>
								<?php endforeach; ?>
							</table>
                            <?php echo $__env->make('elements/_per_page_select', ["items" => $automations], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
							<?php echo e($automations->links()); ?>

						<?php elseif(!empty(request()->keyword)): ?>
							<div class="empty-list">
								<i class="icon-paperplane"></i>
								<span class="line-1">
									<?php echo e(trans('messages.no_search_result')); ?>

								</span>
							</div>
						<?php else: ?>
							<div class="empty-list">
								<i class="icon-alarm-check"></i>
								<span class="line-1">
									<?php echo e(trans('messages.automation_empty_line_1')); ?>

								</span>
							</div>
						<?php endif; ?>
