<?php $__env->startSection('title', trans('messages.subscription')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
            <li class="active"><?php echo e(trans('messages.subscription')); ?></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-quill4"></i> <?php echo e(Auth::user()->customer->displayName()); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make("account._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        <div class="col-sm-12 col-md-8 col-lg-8">
            <h2 class="text-semibold"><?php echo e(trans('messages.subscription')); ?></h2>

            <div class="sub-section">
                <h3 class="text-semibold"><?php echo e(trans('messages.current_plan')); ?> </h3>

                <?php if(!$subscription->isActive()): ?>
                    <?php if($subscription->isDisabled()): ?>
                        <p>
                            <?php echo trans('messages.current_plan_disabled_intro', [
                                'plan' => $subscription->plan_name
                            ]); ?>

                        </p>

                        <?php echo $__env->make('subscriptions._details', ['subscription' => $subscription], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                    <?php elseif(!$subscription->isPaid()): ?>
                        <p>
                            <?php echo trans('messages.current_plan_notactive_intro', [
                                'plan' => $subscription->plan_name,
                            ]); ?>

                        </p>

                        <?php if(!$subscription->isPaid() && !$subscription->isActive()): ?>
                            <ul class="dotted-list topborder section mb-0">
                                <li class="border-bottom-0">
                                    <div class="unit size1of2 text-bold">
                                        <strong><?php echo e(trans('messages.price')); ?></strong>
                                    </div>
                                    <div class="lastUnit size1of2">
                                        <h5 class="mt-0 mb-0 text-semibold">
                                            <mc:flag>
                                                <?php if($subscription->price): ?>
                                                    <?php echo e(Acelle\Library\Tool::format_price($subscription->price, $subscription->currency_format)); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans('messages.free')); ?>

                                                <?php endif; ?>
                                            </mc:flag>
                                        </h5>
                                    </div>
                                </li>
                            </ul>
                        <?php endif; ?>

                        <?php echo $__env->make('subscriptions._details', ['subscription' => $subscription], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                        <?php if(!$subscription->isPaid() && !$subscription->isActive()): ?>
                            <?php if(Auth::user()->customer->can('pay', $subscription)): ?>

                                <?php foreach(\Acelle\Model\PaymentMethod::getAllActive() as $payment_method): ?>
                                    <?php if($payment_method->type != \Acelle\Model\PaymentMethod::TYPE_CASH): ?>
                                        <?php if(
                                            $subscription->isValidPaymentMethod($payment_method)
                                        ): ?>
                                            <span class="mb-10">
                                                <a
                                                    href="<?php echo e(action('SubscriptionController@selectPaymentMethod', ["uid" => $subscription->uid, 'payment_method_id' => $payment_method->uid])); ?>"
                                                    class="btn bg-teal"
                                                >
                                                    <?php echo trans('messages.payment_method_type_' . $payment_method->type . '_button'); ?>

                                                </a>
                                            </span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    <?php else: ?>
                        <p>
                            <?php echo trans('messages.current_plan_notactive_paid_intro' . ($subscription->isTimeUnlimited() ? '_unlimited' : ''), [
                                'plan' => $subscription->plan_name
                            ]); ?>

                        </p>

                        <?php echo $__env->make('subscriptions._details', ['subscription' => $subscription], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php endif; ?>

                    <?php if(\Auth::user()->customer->can('delete', $subscription)): ?>
                        <a data-method="DELETE" delete-confirm="<?php echo e(trans('messages.delete_subscriptions_confirm')); ?>" href="<?php echo e(action('SubscriptionController@delete', ["uids" => $subscription->uid])); ?>"
                            class="btn bg-grey-300 link-method"
                        >
                            <i class="icon-trash"></i> <?php echo e(trans('messages.cancel')); ?>

                        </a>
                    <?php endif; ?>
                <?php else: ?>
                    <?php echo trans('messages.current_plan_intro' . ($subscription->isTimeUnlimited() ? '_unlimited' : ''), [
                        'plan' => $subscription->plan_name,
                        'remain' => ($subscription->end_at ? \Acelle\Library\Tool::dateTime($subscription->end_at)->diffForHumans(null, true) : 0),
                        'end_at' => \Acelle\Library\Tool::formatDate($subscription->end_at)
                    ]); ?>


                    <ul class="dotted-list topborder section">
                        <li>
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.plan_name')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><?php echo e($subscription->plan_name); ?></mc:flag>
                            </div>
                        </li>
                        <li class="selfclear">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.start_at')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><?php echo e($subscription->start_at ? \Acelle\Library\Tool::dateTime($subscription->start_at)->format(trans('messages.date_format')) : ''); ?></mc:flag>
                            </div>
                        </li>
                        <?php if(!$subscription->isTimeUnlimited()): ?>
                            <li class="selfclear">
                                <div class="unit size1of2">
                                    <strong><?php echo e(trans('messages.end_at')); ?></strong>
                                </div>
                                <div class="lastUnit size1of2">
                                    <mc:flag><?php echo e($subscription->end_at ? \Acelle\Library\Tool::dateTime($subscription->end_at)->format(trans('messages.date_format')) : ''); ?></mc:flag>
                                </div>
                            </li>
                            <li>
                                <div class="unit size1of2">
                                    <strong><?php echo e(trans_choice('messages.days_remain', $subscription->daysRemainCount())); ?></strong>
                                </div>
                                <div class="lastUnit size1of2">
                                    <mc:flag><?php echo e($subscription->daysRemainCount()); ?></mc:flag>
                                </div>
                            </li>
                        <?php else: ?>
                            <li class="selfclear">
                                <div class="unit size1of2">
                                    <strong><?php echo e(trans('messages.end_at')); ?></strong>
                                </div>
                                <div class="lastUnit size1of2">
                                    <mc:flag><?php echo e(trans('messages.unlimited')); ?></mc:flag>
                                </div>
                            </li>
                            <li>
                                <div class="unit size1of2">
                                    <strong><?php echo e(trans_choice('messages.days_remain', $subscription->daysRemainCount())); ?></strong>
                                </div>
                                <div class="lastUnit size1of2">
                                    <mc:flag><?php echo e(trans('messages.unlimited')); ?></mc:flag>
                                </div>
                            </li>
                        <?php endif; ?>
                        <li class="more">
                            <a href="#more"><?php echo e(trans('messages.more_details')); ?></a>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.sending_total_quota_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->getSendingQuotaUsage())); ?>/<?php echo e((Auth::user()->customer->getSendingQuota() == -1) ? '∞' : \Acelle\Library\Tool::format_number(Auth::user()->customer->getSendingQuota())); ?></span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySendingQuotaUsage()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.sending_limit')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><?php echo e($subscription->displayQuota()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_lists_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->listsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxLists())); ?></span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayListsUsage()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_subscribers_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->readCache('SubscriberCount', 0))); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxSubscribers())); ?></span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySubscribersUsage()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_campaigns_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->campaignsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxCampaigns())); ?></span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayCampaignsUsage()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_automations_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->automationsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxAutomations())); ?></span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayAutomationsUsage()); ?></mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_size_upload_total_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><span class="text-muted progress-xxs"><?php echo e(\Acelle\Library\Tool::format_number(round(Auth::user()->customer->totalUploadSize(),2))); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxTotalUploadSize())); ?> (MB)</span>
                                &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->totalUploadSizeUsage()); ?>%</mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.max_file_size_upload_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag><?php echo e($subscription->displayFileSizeUpload()); ?> MB</mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.allow_create_sending_servers_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag>
                                    <?php if(Auth::user()->customer->can("create", new Acelle\Model\SendingServer())): ?>
                                        <span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->sendingServersCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxSendingServers())); ?></span>
                                        &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySendingServersUsage()); ?>

                                    <?php else: ?>
                                        <?php echo $subscription->displayAllowCreateSendingServer(); ?>

                                    <?php endif; ?>
                                </mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.allow_create_sending_domains_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag>
                                    <?php if(Auth::user()->customer->can("create", new Acelle\Model\SendingDomain())): ?>
                                        <span class="text-muted"><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->sendingDomainsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxSendingDomains())); ?></span>
                                        &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySendingDomainsUsage()); ?>

                                    <?php else: ?>
                                        <?php echo $subscription->displayAllowCreateSendingDomain(); ?>

                                    <?php endif; ?>
                                </mc:flag>
                            </div>
                        </li>
                        <li class="hide">
                            <div class="unit size1of2">
                                <strong><?php echo e(trans('messages.allow_create_email_verification_servers_label')); ?></strong>
                            </div>
                            <div class="lastUnit size1of2">
                                <mc:flag>
                                    <?php if(Auth::user()->customer->can("create", new Acelle\Model\EmailVerificationServer())): ?>
                                        <span class=""><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->emailVerificationServersCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxEmailVerificationServers())); ?></span>
                                        &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayEmailVerificationServersUsage()); ?>

                                    <?php else: ?>
                                        <?php echo $subscription->displayAllowCreateEmailVerificationServer(); ?>

                                    <?php endif; ?>
                                </mc:flag>
                            </div>
                        </li>
                    </ul>
                <?php endif; ?>
            </div>
            <?php if(!$subscription->isTimeUnlimited()): ?>
                    <div class="sub-section">
                    <?php if(!$nextSubscription): ?>
                        <?php if(\Auth::user()->customer->can('create', new Acelle\Model\Subscription())): ?>
                            <h3><?php echo e(trans('messages.available_plans')); ?></h3>
                            <p><?php echo e(trans('messages.plan.renew.wording')); ?></p>
                            <form enctype="multipart/form-data" action="<?php echo e(action('SubscriptionController@store')); ?>" method="POST" class="form-validate-jqueryz subscription-form">
                                <?php echo e(csrf_field()); ?>


                                <?php echo $__env->make('helpers.form_control', [
                                    'type' => 'select_ajax',
                                    'class' => 'subsciption-plan-select hook',
                                    'name' => 'plan_uid',
                                    'label' => trans('messages.plan'),
                                    'selected' => [],
                                    'help_class' => 'subscription',
                                    'rules' => $subscription->rules(),
                                    'url' => action('PlanController@select2'),
                                    'placeholder' => trans('messages.select_plan')
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                <div class="ajax-detail-box" data-url="<?php echo e(action('SubscriptionController@preview')); ?>" data-form=".subscription-form">
                                </div>
                            </form>
                        <?php endif; ?>
                    <?php elseif(!$nextSubscription->isActive()): ?>
                        <h3><?php echo e(trans('messages.next_plan')); ?></h3>

                        <p>
                            <?php echo trans('messages.next_plan_notactive_intro', [
                                'plan' => $nextSubscription->plan_name
                            ]); ?>

                        </p>

                        <?php if(!$nextSubscription->isPaid() && !$nextSubscription->isActive()): ?>
                            <ul class="dotted-list topborder section mb-0">
                                <li class="border-bottom-0">
                                    <div class="unit size1of2 text-bold">
                                        <strong><?php echo e(trans('messages.price')); ?></strong>
                                    </div>
                                    <div class="lastUnit size1of2">
                                        <h5 class="mt-0 mb-0 text-semibold">
                                            <mc:flag>
                                                <?php if($nextSubscription->price): ?>
                                                    <?php echo e(Acelle\Library\Tool::format_price($nextSubscription->price, $nextSubscription->currency_format)); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans('messages.free')); ?>

                                                <?php endif; ?>
                                            </mc:flag>
                                        </h5>
                                    </div>
                                </li>
                            </ul>
                        <?php endif; ?>

                        <?php echo $__env->make('subscriptions._details', ['subscription' => $nextSubscription], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                        <?php if(!$nextSubscription->isPaid() && !$nextSubscription->isActive()): ?>
                            <?php if(Auth::user()->customer->can('pay', $nextSubscription)): ?>

                                <?php foreach(\Acelle\Model\PaymentMethod::getAllActive() as $payment_method): ?>
                                    <?php if($payment_method->type != \Acelle\Model\PaymentMethod::TYPE_CASH): ?>
                                        <?php if(
                                            $nextSubscription->isValidPaymentMethod($payment_method)
                                        ): ?>
                                            <span class="mb-10">
                                                <a
                                                    href="<?php echo e(action('SubscriptionController@selectPaymentMethod', ["uid" => $nextSubscription->uid, 'payment_method_id' => $payment_method->uid])); ?>"
                                                    class="btn bg-teal"
                                                >
                                                    <?php echo trans('messages.payment_method_type_' . $payment_method->type . '_button'); ?>

                                                </a>
                                            </span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; ?>

                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if(\Auth::user()->customer->can('delete', $nextSubscription)): ?>
                            <a data-method="DELETE" delete-confirm="<?php echo e(trans('messages.delete_subscriptions_confirm')); ?>" href="<?php echo e(action('SubscriptionController@delete', ["uids" => $nextSubscription->uid])); ?>"
                                class="btn bg-grey-300 link-method"
                            >
                                <i class="icon-trash"></i> <?php echo e(trans('messages.cancel')); ?>

                            </a>
                        <?php endif; ?>
                    <?php else: ?>
                        <h3><?php echo e(trans('messages.next_plan')); ?></h3>
                        <p>
                            <?php echo trans('messages.next_plan_active_intro', [
                                'plan' => $nextSubscription->plan_name,
                                'remain' => \Acelle\Library\Tool::dateTime($nextSubscription->end_at)->diffForHumans(null, true),
                                'start_at' => \Acelle\Library\Tool::formatDate($nextSubscription->start_at)
                            ]); ?>

                        </p>

                        <?php echo $__env->make('subscriptions._details', ['subscription' => $nextSubscription], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>