<div class="panel panel-plan mr-30 <?php echo e($subscription->beingUsed() ? 'box-shadow border-dark' : ''); ?>">
    <div class="panel-heading <?php echo e($subscription->beingUsed() ? 'bg-teal-800' : 'bg-grey-800'); ?> subscription-state subscription-state-<?php echo e($subscription->timeStatus()); ?>">
        <h4 class="pull-left panel-title text-center">
            <?php echo e($subscription->plan_name); ?>

        </h4>
        <span class="label label-flat bg-white pull-right">
                        <?php echo e(trans('messages.subscription_time_status_' . $subscription->timeStatus())); ?></span>
    </div>
    <div class="panel-body pt-0 subscription-state subscription-state-<?php echo e($subscription->timeStatus()); ?>">
        <ul class="mt-0 mb-0 top-border-none plans-intro">
            <li>
                <?php if($subscription->beingUsed()): ?>
                    <?php echo e(trans_choice('messages.days_remain', $subscription->daysRemainCount())); ?>:
                    <span class="text-bold text-warning"><?php echo e($subscription->daysRemainCount()); ?></span>
                <?php else: ?>
                    <?php echo e(trans_choice('messages.days_remain', 0)); ?>:
                    <span class="text-bold">--</span>
                <?php endif; ?>
            </li>
            <li>
                <?php echo e(trans('messages.start_at')); ?>: <span class="text-bold">
                    <?php echo e($subscription->start_at ? \Acelle\Library\Tool::dateTime($subscription->start_at)->format(trans('messages.date_format')) : ''); ?>

                </span>
            </li>
            <li>
                <?php echo e(trans('messages.end_at')); ?>: <span class="text-bold">
                    <?php echo e($subscription->end_at ? \Acelle\Library\Tool::dateTime($subscription->end_at)->format(trans('messages.date_format')) : ''); ?>

                </span>
            </li>
            <li>
                <?php echo e(trans('messages.status')); ?>: <span class="text-muted2 list-status">
                    <span class="label label-flat bg-<?php echo e($subscription->status); ?>">
                        <?php echo e(trans('messages.subscription_status_' . $subscription->status)); ?></span>
                </span>
            </li>
            <li>
                <h4 class="text-semibold text-teal-800 mb-0"><?php echo e(trans('messages.options')); ?></h4>
            </li>
            <li>
                <?php echo trans('messages.sending_total_quota_intro', ["value" => $subscription->displayTotalQuota()]); ?>

            </li>
            <li>
                <?php echo trans('messages.sending_quota_intro', ["value" => $subscription->displayQuota()]); ?>

            </li>
            <li>
                <?php echo trans('messages.max_lists_intro', ["value" => $subscription->displayMaxList()]); ?>

            </li>
            <li>
                <?php echo trans('messages.max_subscribers_intro', ["value" => $subscription->displayMaxSubscriber()]); ?>

            </li>
            <li>
                <?php echo trans('messages.max_campaigns_intro', ["value" => $subscription->displayMaxCampaign()]); ?>

            </li>
            <li>
                <?php echo trans('messages.max_size_upload_total_intro', ["value" => $subscription->displayMaxSizeUploadTotal()]); ?>

            </li>
            <li>
                <?php echo trans('messages.max_file_size_upload_intro', ["value" => $subscription->displayFileSizeUpload()]); ?>

            </li>
            <li>
                <?php echo trans('messages.allow_create_sending_servers_intro', ["value" => $subscription->displayAllowCreateSendingServer()]); ?>

            </li>
            <li>
                <?php echo trans('messages.allow_create_sending_domains_intro', ["value" => $subscription->displayAllowCreateSendingDomain()]); ?>

            </li>
        </ul>
    </div>
    <?php if(!isset($readonly)): ?>
        <div class="panel-footer pt-10 pb-10 text-left">

            <?php if(Auth::user()->can('delete', $subscription)
                || Auth::user()->can('pay', $subscription)
            ): ?>
                <div class="btn-group">
                    <button type="button" class="btn bg-teal-800 dropdown-toggle" data-toggle="dropdown">
                    <i class="icon-loop4"></i> <?php echo e(trans('messages.actions')); ?> <span class="caret ml-0"></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-left">
                        <?php if(!$subscription->isPaid() && !$subscription->isActive()): ?>
                            <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('pay', $subscription)): ?>
                                <?php foreach(\Acelle\Model\PaymentMethod::getAllActive() as $payment_method): ?>
                                    <li>
                                        <a href="<?php echo e(action('SubscriptionController@selectPaymentMethod', ["uid" => $subscription->uid, 'payment_method_id' => $payment_method->uid])); ?>">
                                            <?php echo trans('messages.payment_method_type_' . $payment_method->type . '_button'); ?>

                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('delete', $subscription)): ?>
                            <li>
                                <a delete-confirm="<?php echo e(trans('messages.delete_subscriptions_confirm')); ?>" href="<?php echo e(action('SubscriptionController@delete', ["uids" => $subscription->uid])); ?>">
                                    <i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
