<script>
    <?php foreach(['danger', 'warning', 'success', 'info', 'error', 'warning'] as $msg): ?>

        <?php if(Session::has('alert-' . $msg)): ?>

            $(document).ready(function() {
                // Success alert
                swal({
                    title: "<?php echo e(preg_replace('/[\r\n]+/', ' ', Session::get('alert-' . $msg))); ?>",
                    text: "",
                    confirmButtonColor: "#00695C",
                    type: "<?php echo e($msg); ?>",
                    allowOutsideClick: true,
                    confirmButtonText: "<?php echo e(trans('messages.ok')); ?>",
                    customClass: "swl-<?php echo e($msg); ?>"
                });

            });

        <?php endif; ?>
    <?php endforeach; ?>

    <?php if(request()->session()->get('user-activated')): ?>
        $(document).ready(function() {
            // Success alert
            swal({
                title: "<?php echo request()->session()->get('user-activated'); ?>",
                text: "",
                confirmButtonColor: "#00695C",
                type: "success",
                allowOutsideClick: true,
                confirmButtonText: "<?php echo e(trans('messages.ok')); ?>",
                customClass: "swl-success",
                html:true
            });

        });
        <?php request()->session()->forget('user-activated'); ?>
    <?php endif; ?>
</script>
