<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(\Acelle\Model\Setting::get("site_name")); ?></title>

	<?php echo $__env->make('layouts._favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._js', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<script>
		$.cookie('last_language_code', '<?php echo e(Auth::user()->customer->getLanguageCode()); ?>');
	</script>

</head>

<body class="navbar-top color-scheme-<?php echo e(Auth::user()->customer->getColorScheme()); ?>">

	<!-- Main navbar -->
	<div class="navbar navbar-<?php echo e(Auth::user()->customer->getColorScheme() == "white" ? "default" : "inverse"); ?> navbar-fixed-top">
		<div class="navbar-header">
			<a class="navbar-brand" href="<?php echo e(action('HomeController@index')); ?>">
				<?php if(\Acelle\Model\Setting::get('site_logo_small')): ?>
                    <img src="<?php echo e(URL::asset(\Acelle\Model\Setting::get('site_logo_small'))); ?>" alt="">
                <?php else: ?>
                    <img src="<?php echo e(URL::asset('images/default_site_logo_small_' . (Auth::user()->customer->getColorScheme() == "white" ? "dark" : "light") . '.png')); ?>" alt="">
                <?php endif; ?>
			</a>

			<ul class="nav navbar-nav pull-right visible-xs-block">
				<li><a class="mobile-menu-button" data-toggle="collapse" data-target="#navbar-mobile"><i class="icon-menu7"></i></a></li>
			</ul>
		</div>

		<div class="navbar-collapse collapse" id="navbar-mobile">
			<ul class="nav navbar-nav">
				<li rel0="HomeController">
					<a href="<?php echo e(action('HomeController@index')); ?>">
						<i class="icon-home"></i> <?php echo e(trans('messages.dashboard')); ?>

					</a>
				</li>
				<li rel0="CampaignController">
					<a href="<?php echo e(action('CampaignController@index')); ?>">
						<i class="icon-paperplane"></i> <?php echo e(trans('messages.campaigns')); ?>

					</a>
				</li>
				<li rel0="AutomationController">
					<a href="<?php echo e(action('AutomationController@index')); ?>">
						<i class="icon-alarm-check"></i> <?php echo e(trans('messages.Automations')); ?>

					</a>
				</li>
				<li
					rel0="MailListController"
					rel1="FieldController"
					rel2="SubscriberController"
					rel3="SegmentController"
				>
					<a href="<?php echo e(action('MailListController@index')); ?>"><i class="icon-address-book2"></i> <?php echo e(trans('messages.lists')); ?></a>
				</li>
                <li rel0="TemplateController">
					<a href="<?php echo e(action('TemplateController@index')); ?>">
						<i class="icon-magazine"></i> <?php echo e(trans('messages.templates')); ?>

					</a>
				</li>
				<?php if(
					Auth::user()->customer->can("read", new Acelle\Model\SendingServer()) ||
					Auth::user()->customer->can("read", new Acelle\Model\SendingDomain()) ||
                    Auth::user()->customer->can("read", new Acelle\Model\EmailVerificationServer()) ||
					Auth::user()->customer->can("read", new Acelle\Model\Blacklist())
				): ?>
					<li class="dropdown language-switch"
						rel0="SendingServerController"
						rel1="SendingDomainController"
                        rel2="EmailVerificationServerController"
						rel3="BlacklistController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="glyphicon glyphicon-transfer"></i> <?php echo e(trans('messages.sending')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->customer->can("read", new Acelle\Model\SendingServer())): ?>
								<li rel0="SendingServerController">
									<a href="<?php echo e(action('SendingServerController@index')); ?>">
										<i class="icon-server"></i> <?php echo e(trans('messages.sending_servers')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->customer->can("read", new Acelle\Model\SendingDomain())): ?>
								<li rel0="SendingDomainController">
									<a href="<?php echo e(action('SendingDomainController@index')); ?>">
										<i class="icon-earth"></i> <?php echo e(trans('messages.sending_domains')); ?>

									</a>
								</li>
							<?php endif; ?>
                            <?php if(Auth::user()->customer->can("read", new Acelle\Model\EmailVerificationServer())): ?>
								<li rel0="EmailVerificationServerController">
									<a href="<?php echo e(action('EmailVerificationServerController@index')); ?>">
										<i class="icon-database-check"></i> <?php echo e(trans('messages.email_verification_servers')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->customer->can("read", new Acelle\Model\Blacklist())): ?>
								<li rel0="BlacklistController">
									<a href="<?php echo e(action('BlacklistController@index')); ?>">
										<i class="glyphicon glyphicon-minus-sign"></i> <?php echo e(trans('messages.blacklist')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>
			</ul>

			<ul class="nav navbar-nav navbar-right">
				<!--<li class="dropdown language-switch">
					<a class="dropdown-toggle" data-toggle="dropdown">
						<?php echo e(Acelle\Model\Language::getByCode(Config::get('app.locale'))->name); ?>

						<span class="caret"></span>
					</a>

					<ul class="dropdown-menu">
						<?php foreach(Acelle\Model\Language::getAll() as $language): ?>
							<li class="<?php echo e(Acelle\Model\Language::getByCode(Config::get('app.locale'))->code == $language->code ? "active" : ""); ?>">
								<a><?php echo e($language->name); ?></a>
							</li>
						<?php endforeach; ?>
					</ul>
                </li>-->

				<!--<li class="dropdown">
					<a href="#" class="dropdown-toggle top-quota-button" data-toggle="dropdown" data-url="<?php echo e(action("AccountController@quotaLog")); ?>">
						<i class="icon-stats-bars4"></i>
						<span class="visible-xs-inline-block position-right"><?php echo e(trans('messages.used_quota')); ?></span>
					</a>
				</li>-->

				<?php echo $__env->make('layouts._top_activity_log', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				<li class="dropdown dropdown-user">
					<a class="dropdown-toggle" data-toggle="dropdown">
						<img src="<?php echo e(action('CustomerController@avatar', Auth::user()->customer->uid)); ?>" alt="">
						<span><?php echo e(Auth::user()->customer->displayName()); ?></span>
						<i class="caret"></i>
					</a>

					<ul class="dropdown-menu dropdown-menu-right">
						<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check("admin_access", Auth::user())): ?>
							<li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><i class="icon-enter2"></i> <?php echo e(trans('messages.admin_view')); ?></a></li>
							<li class="divider"></li>
						<?php endif; ?>
						<li class="dropdown">
							<a href="#" class="top-quota-button" data-url="<?php echo e(action("AccountController@quotaLog")); ?>">
								<i class="icon-stats-bars4"></i>
								<span class=""><?php echo e(trans('messages.used_quota')); ?></span>
							</a>
						</li>
						<?php if(Auth::user()->customer->can("read", new Acelle\Model\Subscription())): ?>
							<li rel0="AccountController\subscription">
								<a href="<?php echo e(action('AccountController@subscription')); ?>">
									<i class="icon-quill4"></i> <?php echo e(trans('messages.subscriptions')); ?>

								</a>
							</li>
						<?php endif; ?>
						<li><a href="<?php echo e(action("AccountController@profile")); ?>"><i class="icon-profile"></i> <?php echo e(trans('messages.account')); ?></a></li>
						<?php if(Auth::user()->customer->canUseApi()): ?>
							<li rel0="AccountController/api">
								<a href="<?php echo e(action("AccountController@api")); ?>" class="level-1">
									<i class="icon-key position-left"></i> <?php echo e(trans('messages.api')); ?>

								</a>
							</li>
						<?php endif; ?>
						<li><a href="<?php echo e(url("/logout")); ?>"><i class="icon-switch2"></i> <?php echo e(trans('messages.logout')); ?></a></li>
					</ul>
				</li>
			</ul>
		</div>
	</div>
	<!-- /main navbar -->

	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">

			<?php echo $__env->yieldContent('page_header'); ?>

		</div>
	</div>
	<!-- /page header -->

	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- display flash message -->
				<?php echo $__env->make('common.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				<!-- main inner content -->
				<?php echo $__env->yieldContent('content'); ?>

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo trans('messages.copy_right'); ?>

		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<?php echo $__env->make("layouts._modals", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</body>
</html>
