<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(\Acelle\Model\Setting::get("site_name")); ?></title>

	<?php echo $__env->make('layouts._favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._js', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<script>
		$.cookie('last_language_code', '<?php echo e(Auth::user()->admin->getLanguageCode()); ?>');
	</script>

</head>

<body class="navbar-top  color-scheme-<?php echo e(Auth::user()->admin->getColorScheme()); ?>">

	<!-- Main navbar -->
	<div class="navbar navbar-<?php echo e(Auth::user()->admin->getColorScheme() == "white" ? "default" : "inverse"); ?> navbar-fixed-top">
		<div class="navbar-header">
			<a class="navbar-brand" href="<?php echo e(action('Admin\HomeController@index')); ?>">
				<?php if(\Acelle\Model\Setting::get('site_logo_small')): ?>
                    <img src="<?php echo e(URL::asset(\Acelle\Model\Setting::get('site_logo_small'))); ?>" alt="">
                <?php else: ?>
                    <img src="<?php echo e(URL::asset('images/default_site_logo_small_' . (Auth::user()->admin->getColorScheme() == "white" ? "dark" : "light") . '.png')); ?>" alt="">
                <?php endif; ?>
			</a>

			<ul class="nav navbar-nav pull-right visible-xs-block">
				<li><a class="mobile-menu-button" data-toggle="collapse" data-target="#navbar-mobile"><i class="icon-menu7"></i></a></li>
			</ul>
		</div>

		<div class="navbar-collapse collapse" id="navbar-mobile">
			<ul class="nav navbar-nav">
				<li rel0="HomeController">
					<a href="<?php echo e(action('Admin\HomeController@index')); ?>">
						<i class="icon-home"></i> <?php echo e(trans('messages.dashboard')); ?>

					</a>
				</li>

				<?php if(Auth::user()->can("read", new Acelle\Model\Customer())
					|| Auth::user()->admin->can("read", new Acelle\Model\Subscription())
				): ?>
					<li class="dropdown language-switch"
						rel0="CustomerGroupController"
						rel1="CustomerController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="icon-user"></i> <?php echo e(trans('messages.customer')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->can("read", new Acelle\Model\Customer())): ?>
								<li rel0="CustomerController">
									<a href="<?php echo e(action('Admin\CustomerController@index')); ?>">
										<i class="icon-users"></i> <?php echo e(trans('messages.customers')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->can("read", new Acelle\Model\Subscription())): ?>
								<li rel0="SubscriptionController">
									<a href="<?php echo e(action('Admin\SubscriptionController@index')); ?>">
										<i class="icon-quill4"></i> <?php echo e(trans('messages.subscriptions')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>

				<?php if(
					Auth::user()->can("read", new Acelle\Model\Plan())
					|| Auth::user()->can("read", new Acelle\Model\Currency())
					|| Auth::user()->can("read", new Acelle\Model\PaymentMethod())
				): ?>
					<li class="dropdown language-switch"
						rel0="PlanController"
						rel1="CurrencyGroupController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="icon-credit-card2"></i> <?php echo e(trans('messages.plan')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->can("read", new Acelle\Model\Plan())): ?>
								<li rel0="PlanController">
									<a href="<?php echo e(action('Admin\PlanController@index')); ?>">
										<i class="icon-clipboard2"></i> <?php echo e(trans('messages.plans')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->can("read", new Acelle\Model\Currency())): ?>
								<li rel0="CurrencyController">
									<a href="<?php echo e(action('Admin\CurrencyController@index')); ?>">
										<i class="icon-coins"></i> <?php echo e(trans('messages.currencies')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->can("read", new Acelle\Model\PaymentMethod())): ?>
								<li rel0="PaymentMethodController">
									<a href="<?php echo e(action('Admin\PaymentMethodController@index')); ?>">
										<i class="icon-credit-card2"></i> <?php echo e(trans('messages.payment_methods')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>

				<?php if(
					Auth::user()->admin->getPermission("admin_read") != 'no'
					|| Auth::user()->admin->getPermission("admin_group_read") != 'no'
				): ?>
					<li class="dropdown language-switch"
						rel0="AdminGroupController"
						rel1="AdminController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="icon-user-tie"></i> <?php echo e(trans('messages.admin')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->admin->getPermission("admin_read") != 'no'): ?>
								<li rel0="AdminController">
									<a href="<?php echo e(action('Admin\AdminController@index')); ?>">
										<i class="icon-users"></i> <?php echo e(trans('messages.admins')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("admin_group_read") != 'no'): ?>
								<li rel0="AdminGroupController">
									<a href="<?php echo e(action('Admin\AdminGroupController@index')); ?>">
										<i class="icon-users4"></i> <?php echo e(trans('messages.admin_groups')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>

				<?php if(
					Auth::user()->admin->getPermission("sending_domain_read") != 'no'
					|| Auth::user()->admin->getPermission("sending_server_read") != 'no'
					|| Auth::user()->admin->getPermission("bounce_handler_read") != 'no'
					|| Auth::user()->admin->getPermission("fbl_handler_read") != 'no'
					|| Auth::user()->admin->getPermission("email_verification_server_read") != 'no'
					|| Auth::user()->admin->can('read', new \Acelle\Model\SubAccount())
				): ?>
					<li class="dropdown language-switch"
						rel0="BounceHandlerController"
						rel1="FeedbackLoopHandlerController"
						rel2="SendingServerController"
						rel3="SendingDomainController"
						rel3="SubAccountController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="glyphicon glyphicon-transfer"></i> <?php echo e(trans('messages.sending')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->admin->getPermission("sending_server_read") != 'no'): ?>
								<li rel0="SendingServerController">
									<a href="<?php echo e(action('Admin\SendingServerController@index')); ?>">
										<i class="icon-server"></i> <?php echo e(trans('messages.sending_severs')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->can('read', new \Acelle\Model\SubAccount())): ?>
								<li rel0="SubAccountController">
									<a href="<?php echo e(action('Admin\SubAccountController@index')); ?>">
										<i class="icon-drive"></i> <?php echo e(trans('messages.sub_accounts')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("bounce_handler_read") != 'no'): ?>
								<li rel0="BounceHandlerController">
									<a href="<?php echo e(action('Admin\BounceHandlerController@index')); ?>">
										<i class="glyphicon glyphicon-share"></i> <?php echo e(trans('messages.bounce_handlers')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("fbl_handler_read") != 'no'): ?>
								<li rel0="FeedbackLoopHandlerController">
									<a href="<?php echo e(action('Admin\FeedbackLoopHandlerController@index')); ?>">
										<i class="glyphicon glyphicon-retweet"></i> <?php echo e(trans('messages.feedback_loop_handlers')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("sending_domain_read") != 'no'): ?>
								<li rel0="SendingDomainController">
									<a href="<?php echo e(action('Admin\SendingDomainController@index')); ?>">
										<i class="icon-earth"></i> <?php echo e(trans('messages.sending_domains')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("email_verification_server_read") != 'no'): ?>
								<li rel0="EmailVerificationServerController">
									<a href="<?php echo e(action('Admin\EmailVerificationServerController@index')); ?>">
										<i class="icon-database-check"></i> <?php echo e(trans('messages.email_verification_servers')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>
				<li class="dropdown language-switch"
					rel0="TemplateController"
					rel1="LayoutController"
					rel2="LanguageController"
					rel3="SettingController"
				>
					<a class="dropdown-toggle" data-toggle="dropdown">
						<i class="icon-gear"></i> <?php echo e(trans('messages.setting')); ?>

                        <span class="caret"></span>
					</a>
                    <ul class="dropdown-menu">
						<?php if(
							Auth::user()->admin->getPermission("setting_general") != 'no' ||
							Auth::user()->admin->getPermission("setting_sending") != 'no' ||
							Auth::user()->admin->getPermission("setting_system_urls") != 'no' ||
							Auth::user()->admin->getPermission("setting_background_job") != 'no'
						): ?>
							<li rel0="SettingController">
								<a href="<?php echo e(action('Admin\SettingController@index')); ?>">
									<i class="icon-equalizer2"></i> <?php echo e(trans('messages.all_settings')); ?>

								</a>
							</li>
						<?php endif; ?>
						<?php if(Auth::user()->admin->getPermission("template_read") != 'no'): ?>
							<li rel0="TemplateController">
								<a href="<?php echo e(action('Admin\TemplateController@index')); ?>">
									<i class="icon-magazine"></i> <?php echo e(trans('messages.template_gallery')); ?>

								</a>
							</li>
						<?php endif; ?>
						<?php if(Auth::user()->admin->getPermission("layout_read") != 'no'): ?>
							<li rel0="LayoutController">
								<a href="<?php echo e(action('Admin\LayoutController@index')); ?>">
									<i class="glyphicon glyphicon-file"></i> <?php echo e(trans('messages.page_form_layout')); ?>

								</a>
							</li>
						<?php endif; ?>
						<?php if(Auth::user()->admin->getPermission("language_read") != 'no'): ?>
							<li rel0="LanguageController">
								<a href="<?php echo e(action('Admin\LanguageController@index')); ?>">
									<i class="glyphicon glyphicon-flag"></i> <?php echo e(trans('messages.language')); ?>

								</a>
							</li>
						<?php endif; ?>
                    </ul>
				</li>

				<?php if(
					Auth::user()->admin->getPermission("report_blacklist") != 'no'
					|| Auth::user()->admin->getPermission("report_tracking_log") != 'no'
					|| Auth::user()->admin->getPermission("report_bounce_log") != 'no'
					|| Auth::user()->admin->getPermission("report_feedback_log") != 'no'
					|| Auth::user()->admin->getPermission("report_open_log") != 'no'
					|| Auth::user()->admin->getPermission("report_click_log") != 'no'
					|| Auth::user()->admin->getPermission("report_unsubscribe_log") != 'no'
				): ?>
					<li class="dropdown language-switch"
						rel0="TrackingLogController"
						rel1="OpenLogController"
						rel2="ClickLogController"
						rel3="FeedbackLogController"
						rel4="BlacklistController"
						rel5="UnsubscribeLogController"
						rel6="BounceLogController"
					>
						<a class="dropdown-toggle" data-toggle="dropdown">
							<i class="icon-file-text2"></i> <?php echo e(trans('messages.report')); ?>

							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu">
							<?php if(Auth::user()->admin->getPermission("report_blacklist") != 'no'): ?>
								<li rel0="BlacklistController">
									<a href="<?php echo e(action('Admin\BlacklistController@index')); ?>">
										<i class="glyphicon glyphicon-minus-sign"></i> <?php echo e(trans('messages.blacklist')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_tracking_log") != 'no'): ?>
								<li rel0="TrackingLogController">
									<a href="<?php echo e(action('Admin\TrackingLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.tracking_log')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_bounce_log") != 'no'): ?>
								<li rel0="BounceLogController">
									<a href="<?php echo e(action('Admin\BounceLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.bounce_log')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_feedback_log") != 'no'): ?>
								<li rel0="FeedbackLogController">
									<a href="<?php echo e(action('Admin\FeedbackLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.feedback_log')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_open_log") != 'no'): ?>
								<li rel0="OpenLogController">
									<a href="<?php echo e(action('Admin\OpenLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.open_log')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_click_log") != 'no'): ?>
								<li rel0="ClickLogController">
									<a href="<?php echo e(action('Admin\ClickLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.click_log')); ?>

									</a>
								</li>
							<?php endif; ?>
							<?php if(Auth::user()->admin->getPermission("report_unsubscribe_log") != 'no'): ?>
								<li rel0="UnsubscribeLogController">
									<a href="<?php echo e(action('Admin\UnsubscribeLogController@index')); ?>">
										<i class="icon-file-text2"></i> <?php echo e(trans('messages.unsubscribe_log')); ?>

									</a>
								</li>
							<?php endif; ?>
						</ul>
					</li>
				<?php endif; ?>
			</ul>

			<ul class="nav navbar-nav navbar-right">
				<li class="dropdown dropdown-user">
					<a class="dropdown-toggle" data-toggle="dropdown">
						<img src="<?php echo e(action('AdminController@avatar', Auth::user()->admin->uid)); ?>" alt="">
						<span><?php echo e(Auth::user()->admin->displayName()); ?></span>
						<i class="caret"></i>
					</a>

					<ul class="dropdown-menu dropdown-menu-right">
						<?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check("customer_access", Auth::user())): ?>
							<li><a href="<?php echo e(action("HomeController@index")); ?>"><i class="icon-exit2"></i> <?php echo e(trans('messages.customer_view')); ?></a></li>
							<li class="divider"></li>
						<?php endif; ?>
						<li><a href="<?php echo e(action("Admin\AccountController@profile")); ?>"><i class="icon-profile"></i> <?php echo e(trans('messages.account')); ?></a></li>
						<li rel0="AccountController/api">
							<a href="<?php echo e(action("Admin\AccountController@api")); ?>" class="level-1">
								<i class="icon-key position-left"></i> <?php echo e(trans('messages.api')); ?>

							</a>
						</li>
						<li><a href="<?php echo e(url("/logout")); ?>"><i class="icon-switch2"></i> <?php echo e(trans('messages.logout')); ?></a></li>
					</ul>
				</li>
			</ul>
		</div>
	</div>
	<!-- /main navbar -->

	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">

			<?php echo $__env->yieldContent('page_header'); ?>

		</div>
	</div>
	<!-- /page header -->

	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- display flash message -->
				<?php echo $__env->make('common.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				<!-- main inner content -->
				<?php echo $__env->yieldContent('content'); ?>

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo trans('messages.copy_right'); ?>

		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<?php echo $__env->make("layouts._modals", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</body>
</html>
