<?php if(is_object($plan)): ?>
    <div class="panel panel-plan box-<?php echo e($plan->status); ?>">
        <div class="panel-heading" style="background-color: <?php echo e($plan->color); ?>; color: white">
            <h4 class="pull-left panel-title text-center">													
                <?php echo e($plan->name); ?>

            </h4>
        </div>
        <div class="plan-price-box">
            <?php if($plan->price == 0.0): ?>
                <span class="price"><?php echo e(trans('messages.free')); ?></span>
            <?php else: ?>
                <span class="price"><?php echo e(Acelle\Library\Tool::format_price($plan->price, $plan->currency->format)); ?></span> /
                <?php echo e($plan->displayFrequencyTime()); ?>

            <?php endif; ?>
                
        </div>
        <div class="panel-body pt-0">
            <?php echo $__env->make('admin.plans._features', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
        <div class="panel-footer pt-10 pb-10 text-center">												
            <a href="<?php echo e(action('SubscriptionController@register', $plan->uid)); ?>"
                title="<?php echo e(trans('messages.edit')); ?>"
                class="btn bg-teal-800 btn-icon">
                    <i class="icon icon-checkmark4 pr-0 mr-0"></i> <?php echo e(trans('messages.register')); ?>

            </a>
        </div>
    </div>
<?php endif; ?>