<?php $__env->startSection('title', $customer->displayName()); ?>

<?php $__env->startSection('page_script'); ?>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<div class="page-title">
				<ul class="breadcrumb breadcrumb-caret position-right">
					<li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
					<li><a href="<?php echo e(action("Admin\CustomerController@index")); ?>"><?php echo e(trans('messages.customers')); ?></a></li>
					<li class="active"><?php echo e(trans('messages.update')); ?></li>
				</ul>
				<h1>
					<span class="text-semibold"><i class="icon-profile"></i> <?php echo e($customer->displayName()); ?></span>
				</h1>
			</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	<?php echo $__env->make('admin.customers._tabs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <form class="listing-form"
        sort-url="<?php echo e(action('Admin\SubscriptionController@sort')); ?>"
        data-url="<?php echo e(action('Admin\SubscriptionController@listing')); ?>"
        per-page="<?php echo e(Acelle\Model\Subscription::$itemsPerPage); ?>"
    >
        <input type="hidden" name="customer_uid" value="<?php echo e($customer->uid); ?>" />
        <div class="row top-list-controls">
            <div class="col-md-11">
                <div class="filter-box">
                    <span class="filter-group">
                        <!--<span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>-->
                        <select class="select" name="sort-order">
                            <option value="subscriptions.created_at"><?php echo e(trans('messages.created_at')); ?></option>
                            <option value="subscriptions.start_at"><?php echo e(trans('messages.start_at')); ?></option>
                            <option value="subscriptions.end_at"><?php echo e(trans('messages.end_at')); ?></option>
                        </select>
                        <button class="btn btn-xs sort-direction" rel="desc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
                            <i class="icon-sort-amount-desc"></i>
                        </button>
                    </span>
					<span class="mr-10 input-medium">
						<select placeholder="<?php echo e(trans('messages.plan')); ?>"
							class="select2-ajax"
							name="plan_uid"
							data-url="<?php echo e(action('Admin\PlanController@select2')); ?>">
						</select>
					</span>
					<span class="filter-group">
						<select class="select" name="status">
							<option value=""><?php echo e(trans('messages.all_status')); ?></option>
							<?php foreach(Acelle\Model\Subscription::statusSelectOptions() as $option): ?>
								<option value="<?php echo e($option['value']); ?>">
									<?php echo e($option['text']); ?>

								</option>
							<?php endforeach; ?>
						</select>
					</span>
                    <span class="filter-group">
                        <select class="select" name="time_status">
                            <option value=""><?php echo e(trans('messages.all_times')); ?></option>
                            <?php foreach(Acelle\Model\Subscription::timeStatusSelectOptions() as $option): ?>
                                <option value="<?php echo e($option['value']); ?>">
                                    <?php echo e($option['text']); ?>

                                </option>
                            <?php endforeach; ?>
                        </select>
                    </span>
                    <span class="filter-group">
                        <select class="select" name="paid_status">
                            <option value=""><?php echo e(trans('messages.all_payments')); ?></option>
                            <?php foreach(Acelle\Model\Subscription::paidStatusSelectOptions() as $option): ?>
                                <option value="<?php echo e($option['value']); ?>">
                                    <?php echo e($option['text']); ?>

                                </option>
                            <?php endforeach; ?>
                        </select>
                    </span>
                    <span class="text-nowrap">
                        <input name="search_keyword" class="form-control search mini-input" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
                        <i class="icon-search4 keyword_search_button"></i>
                    </span>
                </div>
            </div>
            <?php if(Auth::user()->admin->can('create', new Acelle\Model\Subscription())): ?>
                <div class="col-md-1 text-right">
                    <a href="<?php echo e(action("Admin\SubscriptionController@create")); ?>" type="button" class="btn bg-info-800">
                        <i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_subscription')); ?>

                    </a>
                </div>
            <?php endif; ?>
        </div>

        <div class="pml-table-container">



        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>