<?php $__env->startSection('title', trans('messages.campaigns') . " - " . trans('messages.recipients')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
            <li><a href="<?php echo e(action("CampaignController@index")); ?>"><?php echo e(trans('messages.campaigns')); ?></a></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-paperplane"></i> <?php echo e($campaign->name); ?></span>
        </h1>

        <?php echo $__env->make('campaigns._steps', ['current' => 1], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(action('CampaignController@recipients', $campaign->uid)); ?>" method="POST" class="form-validate-jqueryz">
        <?php echo e(csrf_field()); ?>


        <h4 class="mb-20 mt-0">
            <?php echo e(trans('messages.choose_lists_segments_for_the_campaign')); ?>

        </h4>

        <div class="addable-multiple-form">
            <div class="addable-multiple-container">
                <?php $num = 0 ?>
                <?php foreach($campaign->getListsSegmentsGroups() as $index =>  $lists_segment_group): ?>
                    <?php echo $__env->make('campaigns._list_segment_form', [
                        'lists_segment_group' => $lists_segment_group,
                        'index' => $num,
                    ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php $num++ ?>
                <?php endforeach; ?>
            </div>
            <br />
            <a
                sample-url="<?php echo e(action('CampaignController@listSegmentForm', $campaign->uid)); ?>"
                href="#add_condition" class="btn btn-info bg-info-800 add-form">
                <i class="icon-plus2"></i> <?php echo e(trans('messages.add_list_segment')); ?>

            </a>
        </div>

        <hr>

        <div class="text-right">
            <button class="btn bg-teal-800"><?php echo e(trans('messages.next')); ?> <i class="icon-arrow-right7"></i> </button>
        </div>
    <form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>