<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title><?php echo $__env->yieldContent('title'); ?></title>

	<?php echo $__env->make('layouts._favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._js', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>

<body class="bg-slate-800 color-scheme-<?php echo e(isset($list) && is_object($list) ? $list->user->getFrontendScheme() : ''); ?>">
	<!-- Page container -->
	<div class="page-container login-container">

		<div class="text-right user-top-right">
			<?php if(is_object(\Auth::user())): ?>
				<a class="dropdown-toggle" data-toggle="dropdown">
					<img src="<?php echo e(action('CustomerController@avatar', Auth::user()->customer->uid)); ?>" alt="">
					<span><?php echo e(Auth::user()->customer->displayName()); ?></span>
				</a>
				/
				<a href="<?php echo e(url("/logout")); ?>"><i class="icon-switch2"></i> <?php echo e(trans('messages.logout')); ?></a>
			<?php else: ?>
				<a class="text-semibold" href="<?php echo e(url("/login")); ?>"><i class="icon-user"></i> <?php echo e(trans('messages.login')); ?></a>
			<?php endif; ?>
		</div>

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

                <?php echo $__env->yieldContent('content'); ?>

            </div>
			<!-- /main content -->

		</div>
		<!-- /page content -->

		<!-- Footer -->
		<div class="footer text-white">
			<?php echo trans('messages.copy_right_light'); ?>

		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->
</body>
</html>
