<?php $__env->startSection('title', $list->name); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <?php echo $__env->make("lists._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make("lists._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php if($list->isVerificationRunning()): ?>
        <div class="sub-section">

            <h3 class="text-semibold"><?php echo e(trans('messages.verification_status')); ?></h3>

            <div class="progress-box" data-url="<?php echo e(action('MailListController@verificationProgress', $list->uid)); ?>">

            </div>
        </div>
    <?php else: ?>
        <div class="sub-section">
            <h3 class="text-semibold"><?php echo e(trans('messages.verification_status')); ?></h3>

            <p><?php echo trans('messages.verification_process_not_running', [
                'verified' => $list->countVerifiedSubscribers(),
                'total' => \Acelle\Library\Tool::format_number($list->readCache('SubscriberCount')),
            ]); ?></p>
            <?php if(!$list->countVerifiedSubscribers() == 0): ?>
            <p>
                <a link-confirm="<?php echo e(trans('messages.reset_list_verification_confirm')); ?>" link-method="POST" class="btn bg-grey-600"
                    href="<?php echo e(action("MailListController@resetVerification", $list->uid)); ?>">
                        <?php echo e(trans('messages.verification.button.reset')); ?>

                </a>
            </p>
            <?php endif; ?>
        </div>

        <?php if($list->readCache('VerifiedSubscribersPercentage', 0) != 1): ?>
            <div class="sub-section">
                <h3 class="text-semibold"><?php echo e(trans('messages.list_verification')); ?></h3>
                <form enctype="multipart/form-data" action="<?php echo e(action('MailListController@startVerification', $list->uid)); ?>" method="POST" class="form-validate-jquery">
                    <?php echo e(csrf_field()); ?>


                    <div class="row">
                        <div class="col-md-6">
                            <?php echo $__env->make('helpers.form_control', [
                                'type' => 'select',
                                'name' => 'email_verification_server_id',
                                'label' => trans('messages.verify_your_list'),
                                'value' => '',
                                'options' => \Auth::user()->customer->emailVerificationServerSelectOptions(),
                                'help_class' => 'verification',
                                'rules' => ['email_verification_server_id' => 'required'],
                                'include_blank' => trans('messages.select_email_verification_server')
                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                            <div class="text-left">
                                <button class="btn bg-teal mr-10"> <?php echo e(trans('messages.verification.button.start')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        <?php endif; ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>