<?php $__env->startSection('title', trans('messages.campaigns') . " - " . trans('messages.template')); ?>

<?php $__env->startSection('page_script'); ?>
<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('tinymce/tinymce.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('js/editor.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/dropzone/js/dropzone.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<div class="page-title">
				<ul class="breadcrumb breadcrumb-caret position-right">
					<li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
					<li><a href="<?php echo e(action("CampaignController@index")); ?>"><?php echo e(trans('messages.campaigns')); ?></a></li>
				</ul>
				<h1>
					<span class="text-semibold"><i class="icon-paperplane"></i> <?php echo e($campaign->name); ?></span>
				</h1>

				<?php echo $__env->make('campaigns._steps', ['current' => 3], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

        <div class="pull-right">
				<?php if($campaign->template_source == 'builder'): ?>
					<a href="<?php echo e(action('CampaignController@templateRebuild', $campaign->uid)); ?>" type="button" class="btn bg-info-800 mr-10">
						<i class="icon icon-pencil"></i> <?php echo e(trans('messages.edit')); ?>

					</a>
				<?php endif; ?>
				<?php if($campaign->type != 'plain-text'): ?>
					<a href="<?php echo e(action('CampaignController@templateSelect', $campaign->uid)); ?>" class="btn btn-info bg-teal-800">
						<i class="icon-loop"></i> <?php echo e(trans('messages.change_template')); ?>

					</a>
				<?php endif; ?>
        </div>
				<h2 class="mt-0"><?php echo e(trans('messages.email_content')); ?></h2>

				<ul class="nav nav-tabs nav-tabs-top top-divided text-semibold" id="myTabs">
					<?php if($campaign->type != 'plain-text'): ?>
						<li class="active">
							<a href="#top-justified-divided-tab1" data-toggle="tab" data-target="#top-justified-divided-tab1">
								<i class="icon-circle-code"></i> <?php echo e(trans('messages.html_version')); ?>

							</a>
						</li>
					<?php endif; ?>
					<li class="plain_text_li <?php echo e(($campaign->type == 'plain-text') ? " active" : ""); ?>">
						<a href="#top-justified-divided-tab2" data-toggle="tab" data-target="#top-justified-divided-tab2">
							<i class="icon-file-text2"></i> <?php echo e(trans('messages.plain_text_version')); ?>

						</a>
					</li>
					<li class="plain_text_li <?php echo e(($campaign->type == 'attachment') ? " active" : ""); ?>">
						<a href="#top-justified-divided-tab3" data-toggle="tab" data-target="#top-justified-divided-tab3">
							<i class="icon-attachment"></i> <?php echo e(trans('messages.attachments')); ?>

						</a>
					</li>
				</ul>
        <form action="<?php echo e(action('CampaignController@template', $campaign->uid)); ?>" method="POST" class="form-validate-jqueryz"  >
			        <?php echo e(csrf_field()); ?>


				<div class="tab-content">

					<?php if($campaign->type != 'plain-text'): ?>
				<div class="tab-pane active" id="top-justified-divided-tab1">

                            <?php if(!$campaign->unsubscribe_url_valid()): ?>
                                <span class="text-semibold text-danger">
                                    <?php echo e(trans('messages.unsubscribe_url_required')); ?>

                                </span>
                            <?php endif; ?>

                            <?php if($campaign->template_source == 'builder'): ?>
                                <textarea class="hide" name="html"><?php echo e($campaign->html); ?></textarea>
                                <iframe class="template_preview" src="<?php echo e(action('CampaignController@templateIframe', $campaign->uid)); ?>"></iframe>
                            <?php else: ?>
                                <?php echo $__env->make('helpers.form_control', ['type' => 'textarea',
                                    'class' => 'clean-editor',
                                    'name' => 'html',
                                    'label' => '',
                                    'value' => $campaign->html,
                                    'rules' => $rules,
                                    'help_class' => 'campaign'
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            <?php endif; ?>
						</div>
					<?php endif; ?>

					<div class="tab-pane<?php echo e(($campaign->type == 'plain-text') ? " active" : ""); ?>" id="top-justified-divided-tab2">
						<?php echo $__env->make('helpers.form_control', ['type' => 'textarea',
                            'class' => 'form-control plain_text_content',
                            'name' => 'plain',
                            'label' => '',
                            'value' => $campaign->plain,
                            'rules' => $rules,
                            'help_class' => 'campaign'
                        ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php if($campaign->template_source != 'builder'): ?>
                    <?php echo $__env->make('elements._tags', ['tags' => Acelle\Model\Template::tags($campaign->defaultMailList)], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php endif; ?>

					</div>
				<div class="text-right" id="previw_next_btn">
					<hr>
					<button class="btn bg-teal-800"><?php echo e(trans('messages.next')); ?> <i class="icon-arrow-right7"></i> </button>
				</div>
				</div>
</form>
<div class="tab-content">
	<!-- tab attachments code start here-->
					<div class="tab-pane<?php echo e(($campaign->type == 'attachment') ? " active" : ""); ?>" id="top-justified-divided-tab3">
          <?php echo $__env->make('campaigns._attachment', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

					</div>
					<!-- end of attachment code here-->
</div>
  <?php echo $__env->make('campaigns._campaign_modals', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>