<?php if(is_object($plan)): ?>
    <div class="panel panel-plan box-<?php echo e($plan->status); ?> box-shadow">
        <div class="panel-heading" style="background-color: <?php echo e($plan->color); ?>; color: white">
            <?php if(!isset($readonly)): ?>
                <div class="pull-right">
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('enable', $plan)): ?>
                        <a link-confirm="<?php echo e(trans('messages.enable_plans_confirm')); ?>" href="<?php echo e(action('Admin\PlanController@enable', ['uids' => $plan->uid])); ?>" title="<?php echo e(trans('messages.enable')); ?>" type="button" class="btn btn-white btn-icon"><i class="icon-checkbox-unchecked2"></i></a>
                    <?php endif; ?>
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('disable', $plan)): ?>
                        <a link-confirm="<?php echo e(trans('messages.disable_plans_confirm')); ?>" href="<?php echo e(action('Admin\PlanController@disable', ['uids' => $plan->uid])); ?>" title="<?php echo e(trans('messages.disable')); ?>" type="button" class="btn btn-white btn-icon"><i class="icon-checkbox-checked2"></i></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <h4 class="pull-left panel-title text-center">													
                <?php echo e($plan->name); ?>

            </h4>
        </div>
        <div class="plan-price-box">
            <?php if($plan->price == 0.0): ?>
                <span class="price"><?php echo e(trans('messages.free')); ?></span>
            <?php else: ?>
                <span class="price"><?php echo e(Acelle\Library\Tool::format_price($plan->price, $plan->currency->format)); ?></span> /
                <?php echo e($plan->displayFrequencyTime()); ?>

            <?php endif; ?>
                
        </div>
        <div class="panel-body pt-0">
            <?php echo $__env->make('admin.plans._features', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
        <?php if(!isset($readonly)): ?>
            <div class="panel-footer pt-10 pb-10 text-center">												
                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('update', $plan)): ?>
                    <a href="<?php echo e(action('Admin\PlanController@edit', $plan->uid)); ?>" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey-800 btn-icon"><i class="icon icon-pencil pr-0 mr-0"></i></a>
                <?php endif; ?>
                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('delete', $plan)): ?>
                    <a list-delete-confirm="<?php echo e(action('Admin\PlanController@deleteConfirm', ['uids' => $plan->uid])); ?>" href="<?php echo e(action('Admin\PlanController@delete', ['uids' => $plan->uid])); ?>" title="<?php echo e(trans('messages.delete')); ?>" type="button" class="btn btn-danger btn-icon"><i class="icon icon-cross2"></i></a>
                <?php endif; ?>												
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>