<?php $__env->startSection('title', trans('messages.upgrade.title.upgrade')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
        </ul>
        <h1>
            <span class="text-gear"><i class="icon-key"></i> <?php echo e(trans('messages.upgrade.title.upgrade')); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="tabbable">
        <?php echo $__env->make("admin.settings._tabs", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <div class="tab-content">
            <div class="row">
                <div class="col-md-6">
                    <?php if(isset($failed)): ?>
                        <p class="alert alert-warning">
                            <?php echo e(trans('messages.upgrade.error.something_wrong')); ?>

                        </p>

                        <h3><?php echo e(trans('messages.upgrade.title.in_progress')); ?></h3>
                        <p><?php echo trans('messages.upgrade.error.cannot_write'); ?></p>
                        <p>
                            <pre><?php echo implode("\n", $failed); ?></pre>
                        </p>
                        <p>
                            <a link-confirm="<?php echo e(trans('messages.upgrade.upgrade_confirm')); ?>" href="<?php echo e(action('Admin\SettingController@doUpgrade')); ?>" type="button" class="btn bg-primary btn-icon" link-method="POST">
                                <?php echo e(trans('messages.upgrade.button.retry')); ?>

                            </a>
                            <a link-confirm="<?php echo e(trans('messages.upgrade.upgrade_cancel')); ?>" href="<?php echo e(action('Admin\SettingController@cancelUpgrade')); ?>" type="button" class="btn bg-grey btn-icon" link-method="POST">
                                <?php echo e(trans('messages.upgrade.button.cancel')); ?>

                            </a>
                        </p>
                    <?php elseif($manager->isNewVersionAvailable()): ?>
                        <h3><?php echo e(trans('messages.upgrade.title.upgrade_confirm')); ?></h3>
                        <p><?php echo trans('messages.upgrade.wording.upgrade', [ 'current' => "<code>{$manager->getCurrentVersion()}</code>", 'new' => "<code>{$manager->getNewVersion()}</code>" ]); ?></p>
                        <p>
                            <a link-confirm="<?php echo e(trans('messages.upgrade.upgrade_confirm')); ?>" href="<?php echo e(action('Admin\SettingController@doUpgrade')); ?>" type="button" class="btn bg-primary btn-icon" link-method="POST">
                                <?php echo e(trans('messages.upgrade.button.upgrade_now')); ?>

                            </a>
                            <a link-confirm="<?php echo e(trans('messages.upgrade.upgrade_cancel')); ?>" href="<?php echo e(action('Admin\SettingController@cancelUpgrade')); ?>" type="button" class="btn bg-grey btn-icon" link-method="POST">
                                <?php echo e(trans('messages.upgrade.button.cancel')); ?>

                            </a>
                        </p>
                    <?php else: ?>
                        <h3><?php echo e(trans('messages.upgrade.title.current')); ?></h3>
                        <p><?php echo trans('messages.upgrade.wording.upload', [ 'current' => "<code>{$manager->getCurrentVersion()}</code>" ]); ?></p>
                        <form action="<?php echo e(action('Admin\SettingController@uploadApplicationPatch')); ?>" class="form-validate-jquery" method="POST"  enctype="multipart/form-data">
                            <?php echo e(csrf_field()); ?>


                            <?php echo $__env->make('helpers.form_control', ['required' => true, 'type' => 'file', 'label' => '', 'name' => 'file', 'value' => 'Upload'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            <button class="btn bg-teal"><?php echo e(trans('messages.upload')); ?></button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>