<?php if($templates->count() > 0): ?>
    <table class="table table-box pml-table"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>">
        <?php foreach($templates as $key => $template): ?>
            <tr>
                <td width="1%">
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                            <label>
                                <input type="checkbox" class="node styled"
                                    custom-order="<?php echo e($template->custom_order); ?>"
                                    name="ids[]"
                                    value="<?php echo e($template->uid); ?>"
                                />
                            </label>
                        </div>
                        <?php if(request()->sort_order == 'custom_order' && request()->from == 'mine' && empty(request()->keyword)): ?>
                            <i data-action="move" class="icon icon-more2 list-drag-button"></i>
                        <?php endif; ?>
                    </div>
                </td>
                <td width="1%">
                    <a href="#"  onclick="popupwindow('<?php echo e(action('TemplateController@preview', $template->uid)); ?>', '<?php echo e($template->name); ?>', 800, 800)">
                        <img class="template-thumb" width="100" height="120" src="<?php echo e(action('TemplateController@image', $template->uid)); ?>?v=<?php echo e(rand(0,10)); ?>" />
                    </a>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search" href="#" onclick="popupwindow('<?php echo e(action('TemplateController@preview', $template->uid)); ?>', '<?php echo e($template->name); ?>', 800, 800)">
                            <?php echo e($template->name); ?>

                        </a>
                    </h5>
                    <span class="text-muted">
                        <?php echo is_object($template->admin) ? '<i class="icon-user-tie"></i>' . $template->admin->displayName() : ''; ?>

                        <?php echo is_object($template->customer) ? '<i class="icon-user"></i>' . $template->customer->displayName() : ''; ?>

                    </span>
                    <br>
                    <span class="text-muted"><?php echo e(trans('messages.updated_at')); ?>: <?php echo e(Tool::formatDateTime($template->created_at)); ?></span>
                </td>

                <td>
                    <div class="single-stat-box pull-left">
                        <span class="no-margin stat-num"><?php echo e(trans('messages.template_type_' . $template->source)); ?></span>
                        <br>
                        <span class="text-muted text-nowrap"><?php echo e(trans('messages.type')); ?></span>
                    </div>
                </td>

                <td class="text-right">
                    <?php if(Auth::user()->customer->can('update', $template)): ?>
                        <?php if($template->source == 'builder'): ?>
                            <a href="<?php echo e(action('TemplateController@rebuild', $template->uid)); ?>" type="button" class="btn bg-grey btn-icon"> <i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
                        <?php else: ?>
                            <a href="<?php echo e(action('TemplateController@edit', $template->uid)); ?>" type="button" class="btn bg-grey btn-icon"> <i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(Auth::user()->customer->can('preview', $template) ||
                        Auth::user()->customer->can('copy', $template) ||
                        Auth::user()->customer->can('delete', $template)): ?>
                        <div class="btn-group">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <?php if(Auth::user()->customer->can('preview', $template)): ?>
                                    <li><a href="#preview" onclick="popupwindow('<?php echo e(action('TemplateController@preview', $template->uid)); ?>', '<?php echo e($template->name); ?>', 800, 800)"><i class="icon-zoomin3"></i> <?php echo e(trans("messages.preview")); ?></a></li>
                                <?php endif; ?>
                                <?php if(Auth::user()->customer->can('copy', $template)): ?>
                                    <li>
                                        <a
                                            href="<?php echo e(action('TemplateController@copy', $template->uid)); ?>"
                                            type="button"
                                            class="modal_link"
                                            data-method="GET"
                                        >
                                            <i class="icon-copy4"></i> <?php echo e(trans("messages.template.copy")); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(Auth::user()->customer->can('delete', $template)): ?>
                                    <li><a delete-confirm="<?php echo e(trans('messages.delete_templates_confirm')); ?>" href="<?php echo e(action('TemplateController@delete', ["uids" => $template->uid])); ?>"><i class="icon-trash"></i> <?php echo e(trans("messages.delete")); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $templates], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($templates->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <i class="icon-magazine"></i>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result')); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-magazine"></i>
        <span class="line-1">
            <?php echo e(trans('messages.template_empty_line_1')); ?>

        </span>
    </div>
<?php endif; ?>
