<div class="form-group control-radio">
    <div class="radio_box" data-popup='tooltip' title="">
        <label class="main-control">
            <input <?php echo e(($options['sending_server_option'] == \Acelle\Model\Plan::SENDING_SERVER_OPTION_SYSTEM ? 'checked' : '')); ?> type="radio"
                name="options[sending_server_option]"
                value="<?php echo e(\Acelle\Model\Plan::SENDING_SERVER_OPTION_SYSTEM); ?>" class="styled" /><rtitle><?php echo e(trans('messages.plan_option.system_s_sending_server')); ?></rtitle>
            <div class="desc text-normal mb-10">
                <?php echo e(trans('messages.plan_option.system_s_sending_server.intro')); ?>

            </div>
        </label>
        <div class="radio_more_box">
            <span class="notoping">
                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox2',
                    'class' => '',
                    'name' => 'options[all_sending_servers]',
                    'value' => $options['all_sending_servers'],
                    'label' => trans('messages.use_all_sending_servers'),
                    'options' => ['no','yes'],
                    'help_class' => $help_class,
                    'rules' => $rules
                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </span>

            <?php if(!Auth()->user()->admin->getAllSendingServers()->count()): ?>
                <div class="alert alert-danger mt-20">
                    <?php echo trans('messages.plan_option.there_no_sending_server'); ?>

                </div>
            <?php else: ?>
                <div class="sending-servers">
                    <hr>
                    <div class="row text-muted">
                        <div class="col-md-6">
                            <label><?php echo e(trans('messages.select_sending_servers')); ?></label>
                        </div>
                        <div class="col-md-6">
                            <label><?php echo e(trans('messages.fitness')); ?></label>
                        </div>
                    </div>
                    <?php foreach(Auth()->user()->admin->getAllSendingServers()->orderBy("name")->get() as $server): ?>
                        <div class="row mb-5">
                            <div class="col-md-6">
                                <?php echo $__env->make('helpers.form_control', [
                                    'type' => 'checkbox2',
                                    'name' => 'sending_servers[' . $server->uid . '][check]',
                                    'value' => $relatedSendingServers->contains('sending_server_id', $server->id),
                                    'label' => $server->name,
                                    'options' => [false, true],
                                    'help_class' => $help_class,
                                    'rules' => $rules
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
                            <div class="col-md-6" show-with-control="input[name='<?php echo e('sending_servers[' . $server->uid . '][check]'); ?>']">
                                <?php $found_key = array_search($server->id, array_column($relatedSendingServers->toArray(), 'sending_server_id')) ?>
                                <?php echo $__env->make('helpers.form_control', [
                                    'type' => 'text',
                                    'class' => 'numeric',
                                    'name' => 'sending_servers[' . $server->uid . '][fitness]',
                                    'label' => '',
                                    'value' => $found_key !== false ? $relatedSendingServers->toArray()[$found_key]["fitness"] : '100',
                                    'help_class' => $help_class,
                                    'rules' => $rules
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

        </div>
    </div>
    <hr>
    <div class="radio_box" data-popup='tooltip' title="">
        <label class="main-control">
            <input <?php echo e(($options['sending_server_option'] == \Acelle\Model\Plan::SENDING_SERVER_OPTION_OWN ? 'checked' : '')); ?> type="radio"
                name="options[sending_server_option]"
                value="<?php echo e(\Acelle\Model\Plan::SENDING_SERVER_OPTION_OWN); ?>" class="styled" /><rtitle><?php echo e(trans('messages.plan_option.own_sending_server')); ?></rtitle>
            <div class="desc text-normal mb-10">
                <?php echo e(trans('messages.plan_option.own_sending_server.intro')); ?>

            </div>
        </label>
        <div class="radio_more_box">
            <div class="boxing">
                <?php echo $__env->make('helpers.form_control', [
                    'type' => 'text',
                    'class' => 'numeric',
                    'name' => 'options[sending_servers_max]',
                    'value' => $options['sending_servers_max'],
                    'label' => trans('messages.max_sending_servers'),
                    'help_class' => $help_class,
                    'options' => ['true', 'false'],
                    'rules' => $rules,
                    'unlimited_check' => true,
                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>

            <p>
                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox2',
                    'class' => '',
                    'name' => 'options[all_sending_server_types]',
                    'value' => $options['all_sending_server_types'],
                    'label' => trans('messages.allow_adding_all_sending_server_types'),
                    'options' => ['no','yes'],
                    'help_class' => $help_class,
                    'rules' => $rules
                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </p>
            <div class="all_sending_server_types_no">
                <hr>
                <label class="text-semibold text-muted"><?php echo e(trans('messages.select_allowed_sending_server_types')); ?></label>
                <div class="row">
                    <?php foreach(Acelle\Model\SendingServer::types() as $key => $type): ?>
                        <div class="col-md-4 pt-10">
                            &nbsp;&nbsp;<span class="text-semibold text-italic"><?php echo e(trans('messages.' . $key)); ?></span>
                            <span class="notoping pull-left">
                                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox',
                                    'class' => '',
                                    'name' => 'options[sending_server_types][' . $key . ']',
                                    'value' => isset($options['sending_server_types'][$key]) ? $options['sending_server_types'][$key] : 'no',
                                    'label' => '',
                                    'options' => ['no','yes'],
                                    'help_class' => $help_class,
                                    'rules' => $rules
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div class="radio_box" data-popup='tooltip' title="">
        <label class="main-control">
            <input <?php echo e(($options['sending_server_option'] == \Acelle\Model\Plan::SENDING_SERVER_OPTION_SUBACCOUNT ? 'checked' : '')); ?> type="radio"
                name="options[sending_server_option]"
                value="<?php echo e(\Acelle\Model\Plan::SENDING_SERVER_OPTION_SUBACCOUNT); ?>" class="styled" /><rtitle><?php echo e(trans('messages.plan_option.sub_account')); ?></rtitle>
            <div class="desc text-normal mb-10">
                <?php echo e(trans('messages.plan_option.sub_account.intro')); ?>

            </div>
        </label>
        <div class="radio_more_box">
            <?php if(Auth()->user()->admin->getSubaccountSendingServers()->count()): ?>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo $__env->make('helpers.form_control', [
                            'type' => 'select',
                            'class' => 'numeric',
                            'name' => 'options[sending_server_subaccount_uid]',
                            'value' => $options['sending_server_subaccount_uid'],
                            'label' => '',
                            'help_class' => $help_class,
                            'include_blank' => trans('messages.select_sending_server_with_subaccount'),
                            'options' => Auth()->user()->admin->getSubaccountSendingServersSelectOptions(),
                            'rules' => $rules
                        ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-danger">
                    <?php echo trans('messages.plan_option.there_no_subaccount_sending_server'); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
